import { motionComponentSymbol } from './symbol.mjs';

/**
 * Checks if a component is a `motion` component.
 */
function isMotionComponent(component) {
    return (component !== null &&
        typeof component === "object" &&
        motionComponentSymbol in component);
}

export { isMotionComponent };
