import { z } from 'zod';
import { creatorRewardsSchema, marketCapSchema } from './schema';

export const errorSchemas = {
  validation: z.object({
    message: z.string(),
    field: z.string().optional(),
  }),
  notFound: z.object({
    message: z.string(),
  }),
  internal: z.object({
    message: z.string(),
  }),
};

export const api = {
  marketCap: {
    get: {
      method: 'GET' as const,
      path: '/api/marketcap/:tokenAddress',
      responses: {
        200: marketCapSchema,
        400: errorSchemas.validation,
        500: errorSchemas.internal,
      },
    },
  },
  rewards: {
    get: {
      method: 'GET' as const,
      path: '/api/rewards/:walletAddress',
      responses: {
        200: creatorRewardsSchema,
        400: errorSchemas.validation,
        500: errorSchemas.internal,
      },
    },
  },
};

export function buildUrl(path: string, params?: Record<string, string | number>): string {
  let url = path;
  if (params) {
    Object.entries(params).forEach(([key, value]) => {
      if (url.includes(`:${key}`)) {
        url = url.replace(`:${key}`, String(value));
      }
    });
  }
  return url;
}
